The following is the Guide to Clueful Chatting archived from the ClueNet Wiki:

# Guide to Clueful Chatting
Typing correctly in Internet chat rooms and even private messages has become a lost art. The vast majority of people participating in these chat rooms do not realize or believe how much of an effect a simple thing such as spelling out the word "you" or capitalizing the word "I" can have on how other people online view them and the content of the conversation. The truth is that the proper use of language online has a very large effect on many of the surroundings. Unfortunately, most people do not realize this and succumb to laziness.

The majority of people realize how to speak/type correctly and recognize this in other people, even if they do not follow the principles themselves. Whether or not a person online types correctly or not, they form a type of respect for those that do. The people that do type correctly benefit from this respect by being put into positions of responsibility or trust. Respect is the phenomenon out of which rises the hierarchy of online chat rooms and it is very important for individuals to gain the respect of others.

In addition to fostering respect and good will, typing correctly promotes intelligent and intellectual exchanges when desired and prevents conversations from disintegrating into arguments filled with animosity or simple flaming wars. A criticism sounds much more valid when presented properly than when filled with cryptic chat acronyms or violations of obvious grammatical rules.

A third advantage of typing correctly is that it sets the speaker apart from those that do not. Internet chat rooms are usually based on a class system of some kind. Sometimes this is based on a technical backend and sometimes this is purely social. In general, those at the lower end of the social spectrum (often referred to as lamers and script kiddies, those that are lazy, have no wish to learn, but want power, and have malicious or selfish intentions) do not follow these rules of proper chatting and typing technique. By following these rules yourself, it sets you apart from them.

Since there is not, to my knowledge, a proper term for describing this method of chatting and typing, a term has been invented to refer to the use of proper capitalization, punctuation, and grammar. This term, "Clueful Chatting", is based on the adjective "Clueful". "Clueful" is a kind of a slang term, but it is in some dictionaries. Webster defines it as "knowledgeable, well-informed, the opposite of clueless", and it seems to be a proper adjective to represent the kind of chatting described here.

The rest of this document describes the various practices of clueful chatting for those that want more specific information. It is provided as a basic reference only and is by no means complete. It only describes basic, finite rules, and some parts only apply to the English language, although many of the points apply to many or all languages. Aspects of speech such as correct spelling and grammar are not discussed here beyond the basics. One should always make their best effort to spell words correctly and use proper grammar if not overly inconvenient, but nobody is perfect in any of these respects.

Here are some well-defined aspects of clueful chatting:

- Use complete sentences when appropriate. Don't use short fragments of a sentence when chatting unless it is useful to be terse.
- Capitalize the first letter of each sentence. This is a basic English rule and applies to most other languages as well.
- Capitalize all instances of the personal pronoun "I". One of the most common problems with online chat is that people very rarely capitalize words like "I", "I'm", and "I'll".
- End sentences with some kind of punctuation. A period, question mark, or exclamation point is preferred, but in some cases, a simple "smiley" can be used instead if the end-of-sentence punctuation could interfere with the smiley.
- Smileys are fine if they are not overused. They can be used to convey emotion in an otherwise emotionless medium, but are harmful if overused. Also, smileys should be kept simple. Elaborate smileys can detract from the clueful chatting.
- Never use multiple question marks or exclamation marks in a row.
- Do not use special color codes or abnormal ascii characters unless absolutely necessary.
- Do not break up a single thought or single sentence onto multiple lines unless a single line would exceed the capabilities of the chat medium.
- Do not use abbreviations for already short words such as "r" for "are" or "u" for "you". Acronyms for longer phrases like "gtg" or "brb" are usually acceptable.
- Do not flood or repeat the same line multiple times.
- Do not use "leetspeak". This includes substituting numbers for letters within words or adding suffixes like "z" on the ends of words.
- Do not type in all or alternating capitals.