# Filesystem

The UNIX filesystem is a hierarchical collection of files and directories.  Directories are containers that can contain named files or directories.  A path in UNIX is separated by `/`, and the root of the filesystem is denoted by `/`, such that `/foo/bar/baz` refers to a file or directory named `baz` inside the `bar` directory that lives in the `foo` directory in the root of the filesystem.

The entries in a directory are called `directory entries`, `dirents`, or `dentries`.  There are minor technical differences between these terms, mostly based on what level of abstraction they typically involve.  A directory entry has a name and points to an `inode`.  Typically this is a 1-to-1 correlation, but it can sometimes be useful to have two different directory entries point to the same inode -- this is called a `hardlink` when it does happen, and means you have two names for the same file.

An inode represents, generally, the concept of a file or directory in the filesystem.  It is where all the properties of what it means to be a file live and as such, I'll use `file` and `inode` interchangeably from now on.

The filesystem can be navigated by using `cd` to change your current directory, and `ls` to list the contents of a directory (or your current directory).  By convention, files starting with a `.` are considered hidden, and you will need to use `ls -a` to see them.  There are two special files in each directory: `.` which refers to this directory and `..` which refers to this directory's containing directory.

## File Properties

A file has a `user`.  This is an integer representing the user ID that owns the file.  This can be changed by using the `chown` tool and viewed with `ls -l`.

A file has a `group`.  This is an integer representing the group ID that owns the file.  This can be changed by using the `chgrp` tool, or the combined set option of the `chown` tool; and viewed with `ls -l`.

A file has a `mode`.  This is typically represented as an octal number, and is often called the `permissions` on the file.  It is a bitfield of flags:

| Mode    | Description |
| -------- | ------- |
| `04000` | Set UID; sets the effective user ID of a process created by executing this file to the `user` of this file. |
| `02000` | Set GID; sets the effective group ID of a process created by executing this file to the `group` of this file. |
| `01000` | Sticky bit; when set on a directory prevents users with write access to the directory from renaming or deleting files in the directory. |
| `00400` | User Read; allows the file's `user` to read the file. |
| `00200` | User Write; allows the file's `user` to write the file. |
| `00100` | User Execute; when set on a directory, allows the file's `user` to access files in the directory; otherwise allows the file's `user` to execute the file. |
| `00040` | Group Read; allows members of the file's `group` to read the file. |
| `00020` | Group Write; allows members of the file's `group` to write the file. |
| `00010` | Group Execute; when set on a directory, allows members of the file's `group` to access files in the directory; otherwise allows members of the file's `group` to execute the file. |
| `00004` | Other Read; allows other users to read the file. |
| `00002` | Other Write; allows other users to write the file. |
| `00001` | Other Execute; when set on a directory, allows other users to access files in the directory; otherwise allows other users to execute the file. |

These can be set using the `chmod` tool and viewed with `ls -l`.

A file may also have extended attributes.  These can be seen by using `lsattr` and `getfattr` tools, and changed using the `chattr` and `setfattr` tools.  These attributes are flags that cause the file to be treated specially, and are typically quite niche.

A file may also have an access control list.  This is a more fine-grained permission system that allows granting specific users and groups specific permissions to files or directories.  These can be seen by using the `getfacl` tool, and changed by using the `setfacl` tool.

A file has a few timestamps.  `ctime` is the creation timestamp, set to the time the file was first created.  `mtime` is the modified timestamp, set to the last time the file was modified.  `atime` is the access timestamp, set to the last time the file was accessed, though many filesystems do not set the `atime` for performance reasons.  These can be viewed with `ls -l`.

# Processes

A `process` on a UNIX system is the result of executing a file.

Each process has:
- an integer ID called its `pid`.
- a parent PID called its `ppid`.
- a `user` and `group` ID.
- argument vector (`argv`)
- environment (`envp`)
- virtual memory + mapping
- a filesystem root
- and a ton of other things.

You can inspect the process table with `ps` (or `ps auxf` for more details).