# General

## Core Mechanics

* First-person perspective primarily, third person toggle  
* UI  
  * Hit points  
  * Stamina  
  * Mana  
  * Hunger  
  * Thirst  
  * Breath meter (when applicable)  
  * Active effects  
    * A row of icons  
    * A duration above the icon  
    * A potency beneath the icon if applicable.  
      * Eg: a poison effect that deals 10 damage/sec will have a 10 beneath it  
      * Numbers may be shortened like damage numbers. Eg: 2.6K  
  * 10 slot item hotbar, bound 1-0 by default  
  * 10 slot ability hotbar  
  * Compass with cardinal directions, home location, quest objectives  
  * Minimap  
  * Exp bar  
  * Chat  
    * Whisper (1:1 or 1:many private messages)  
    * Party (within your party)  
    * Local (within a small radius)  
    * Settlement (within bounds of settlement)  
    * Regional (within a region)  
    * Clan (within your clan)  
  * Name Plates  
    * If sneaking, don’t exist  
    * If no line of sight on a creature, they don’t exist  
    * Normally: Name, Optionally overlevel indicator, Type indicator  
      * Overlevel indicator is a red skull (or similar) that shows up when the creature is more than 10(?) levels above yours  
      * Type indicator indicates base monster, intelligent creature, or Player  
      * Name is colored based on effective reputation (coalesced total of all other reputations used to determine a particular creature’s stance toward another)  
      * Order of name colors:  
        * Party members are dark blue  
        * Friends are dark green  
        * Clan members are light blue  
        * Reputation-based (light-green to light-red)  
* Menus (ESC)  
  * Contains settings & game exit  
  * Equipment/inventory  
    * Items can be equipped, dropped, moved to the item hotbar, and crafted.  
  * Quest log  
    * Quests can be abandoned here  
    * Quests can be shared to applicable party members here  
    * Quests are categorized by settlement & kingdom in collapsable & draggable tabs  
    * Quests are colored based on difficulty and level requirement  
    * Quest timer for each quest can be viewed here  
    * Some quests are prefixed with icons to indicate group quests and pvp quests  
  * Character  
    * Contains class tree tab where points can be distributed  
    * Contains abilities tab with ability info, where abilities can be moved to the ability hotbar  
    * Contains info tab with general overview of character  
    * Contains reputation tab  
  * Social  
    * Contains party tab where party invites can be accepted, the player can leave their party, and the leader can kick players  
    * Contains clan tab where users can manage their clan  
    * Contains friends list tab where:  
      * Friends can be added/removed.  
      * Mutual friends can see each other’s level, class, race, online status, current region & settlement(if applicable), and can receive party invites from anywhere in the world  
    * Contains blocked users tab  
      * Chat messages from blocked users are hidden  
  * Notification/Prompt Queue  
    * Notifications can be “minimized” rather than being dismissed, they then go to the notification queue  
    * Notifications are automatically minimized during combat  
* Resource pools

  All characters have all 3 resource pools regardless of class.

  * Hit points  
    * Health. HP. Reaches 0, you die.  
  * Mana  
    * Used for spell casting  
  * Stamina  
    * Used for running, jumping, climbing, sneaking, crawling, and non-mana-based special attacks/abilities.  
* Block Interaction  
  * Placing  
    * Use block to place unsolidified block, which is an uninteractable entity that is destroyed upon being hit with any item.  
    * Block solidifies after about 10 seconds, after which it has its normal hardness and can be interacted with.  
  * Destroying  
    * Hold attack button to begin mining. Block is destroyed upon completion and yields drops if applicable.  
* [Game Numbers](https://docs.google.com/spreadsheets/d/1DPnJFgnu8F4PPWVguljEsLBHOtwMJ_yHsA0egyQ2_rs/edit?usp=sharing)  
* Death  
  * Player is immediately taken to a dark area with a light. Walking towards the light will respawn the player at the nearest friendly graveyard.  
  * 1 HP, 0 Mana, 0 Stamina, \-50% regeneration, \-50% to all physical attributes debuff for 1 minute, starts when spawned in the underworld.  
  * If the player is resurrected, another light appears. Walking towards the new light will resurrect the player.  
    * Resurrection offer lasts for a few seconds.  
  * 100% of held money is dropped.  
  * 20% of common items dropped.  
  * 1% of uncommon or rare items dropped.  
  * Soulbound will prevent an item from being dropped.  
  * If you are carrying a moonstone, it is destroyed but no items drop.  
* Social wheel  
  * If the player is looking at another player, a social wheel menu can be opened. This is not a window, but a UI element that appears over the player. While the menu is open, the player can not look around as the mouse will be used to select menu buttons.  
  * Menu buttons:  
    * Add friend  
    * Invite to party  
    * Trade(?)(requires close proximity)  
    * Whisper(?)  
    * Inspect(?)(requires close proximity)  
* Parties  
  * Max party size: Leader’s Leadership level (min: 4\)  
  * Friendly fire: No  
  * Members of a party always enter the same instance as leader  
  * Raid Party: A “super-party” where the party members are themselves leaders of squads.  
  * Party XP Distribution: Selectable when the party is formed between  
    * Equal: Everyone in the party gets an equal share of XP  
    * Proportional: XP that comes from damage dealt is split per damage and awarded based on damage dealt  
    * Maybe? Equity: XP is distributed to the lowest level characters in the group more than the highest level characters in the party with a configurable splay of up to 50%  
    * Maybe? Custom: XP is held in a bank until the leader chooses to distribute it, or until the party membership is changed or disbanded.  
  * See Leadership below for more.  
* Day/night cycle  
  * 2 hours; 1 hour day, 1 hour night  
  * Timezones? We don’t know yet  
  * Calendars?  Multiple, per faction  
  * Seasons?  
* Hunger/Thirst  
  * Drinking water restores full thirst  
  * Eating restores some hunger based on food type  
  * Thirst goes down quickly with movement (\~500 blocks, \~250 running)  
  * Hunger goes down with movement (\~2000 blocks, \~1000 running)  
  * Stamina regeneration halves at 30% thirst, stops at 10% thirst  
  * Health regeneration halves at 40% hunger, stops at 20% hunger  
  * Eating well-prepared food can give buffs  
* Maps  
  * Mundane Maps  
    * Work a lot like Minecraft maps.  
    * Can be crafted reasonably simply  
    * Can be pinned into a minimap or opened into a full map screen  
    * Are limited to one region  
      * (Or maybe 2x2?  Not sure yet)  
    * Can be copied to another mundane map or a magical map.  
    * Can be marked and labelled  
  * Magical Map  
    * Craftable, but a lot more expensive, item-wise  
    * Unlimited size, complete with zoom functionality  
    * Can be copied to a mundane map or magical map  
    * Party/friend indicators can be added to map  
    * Can be shared with other magical maps (partially or wholly) for live-updating  
    * Map markers can be made visible in the world and in your compass  
    * Automatically learns names of areas  
    * Automatically learns difficulty rating of areas  
    * Automatically learns biome types  
    * Automatically learns villages and marks reputation with them  
    * Can lay out a fastest route to a point on the map with indicators visible in the world  
    * Can be searched and filtered  
  * Map item?  
    * Yes  
  * UI/window?  
    * Yes.  A minimap and a full map screen  
  * Discover radius?  
    * Something close to render-distance.  160 blocks? 128 blocks?  
  * Updates areas while player is away?  
    * No.  
  * Coordinates?  
    * Probably not.  
* Settings  
  * General  
    * Field of view (horizontal) \[weapon fov too\]  
  * Combat  
    * Toggle weapon zoom  
      * Determines if zoom is hold(default) or toggle.  
    * Zoom field of view  
    * Toggle modifier ability  
      * Determines if modifier abilities (syringe darts, casting manipulation) are enabled by hold or toggle(default).  
    * Show damage numbers  
  * Controls  
    * Look sensitivity  
    * Look sensitivity while zoomed in  
    * Toggle sprint  
      * Determines if the player stops sprinting when the sprint key is released but forward continues to be held, or continues to sprint after sprint key is released(default).  
    * Toggle sneak  
      * Determines if sneak is hold(default) or toggle.  
    * Toggle social wheel  
      * Determines if the social wheel is displayed while the button is held(default), or if the social wheel is toggled.  
    * Controller support?  
    * Key binds  
      * General:  
        * Attack/destroy: left mouse button  
        * Interact/Use held/Place block: right mouse button  
        * ↑←↓→: WASD  
        * Jump: space  
        * Sprint: shift  
        * Crouch: ctrl  
        * Social wheel: Middle mouse button  
      * Item hotbar  
        * 1-10: 1-0  
        * Switch left: mouse wheel up  
        * Switch right: mouse wheel down  
      * Ability hotbar  
        * 1: Q  
        * 2: E  
        * 3: R  
        * 4: F  
        * 5: Z  
        * 6: X  
        * 7: C  
        * 8: V  
        * 9: T  
        * 10: G  
      * Menus  
        * Esc: esc (can’t be rebound)  
        * Character/inventory: I  
        * Quest log: L  
        * Character  
          * Classtree tab: K  
          * Abilities tab: unbound  
          * Party tab: P  
          * Friends list tab: O  
          * Clan tab: unbound  
        * Map: M  
        * Notification queue: N

* Movement  
  * Walking  
    * 4.4 blocks/second  
  * Sprinting  
    * 5.7 blocks/second  
    * \-10% stamina/second  
    * Does not halt stamina regen  
  * Jumping  
    * 1.2 block jump height  
  * Sneaking  
    * 3.5 blocks/second  
    * Reduces hitbox height by amount dependent on race  
    * Increases stealth  
  * Swimming  
    * 4 blocks/second  
    * Decreases stealth if swimming on surface  
    * Increases stealth if swimming below surface	  
  * Sprint-swimming  
    * 5 blocks/second  
    * \-10% stamina/second  
    * Does not halt stamina regen  
  * Climbing  
    * 3 blocks/second  
    * \-20% stamina/second  
    * Does not halt stamina regen  
* Voice chat?

## Characters

Names:

* Must be unique  
* A-Za-z0-9  
* More than 2 characters  
* Less than 26 characters  
* Space, apostrophe, and hyphen is allowed between letters  
* Option to use RNG to generate a name for their character.

Base attributes (Points awarded per character level):

* Strength (General buff to melee attacks)  
* Dexterity (Movement speed, fall damage, buff to ranged attacks)  
* Constitution (General buff to HP)  
* Stamina (General buff to Stamina regen rate; Fixed pool of 1,000,0001.0010000, Stamina Attribute value regenerates continuously over 15 seconds)  
  * Buffs can improve regen speedtime  
  * Buffs can reduce cost of casting improve cost to cast stamina-based moves  
  * Debuffs can slow regen speedtime  
  * Debuffs can increase cost of cause greater cost to stamina-based moves  
  * Don’t make bigger pool of stamina as the “buff”?  
* Magicka (General buff to Mana; regenerates over 2min)  
* Charisma (General buff to reputation)  
  * Consider removing this

Skills (Leveled independently):

* Fighting (Chance to hit)  
  * \+1 Skill XP each successful hit  
  * (See Combat XP)  
* Survival (Armor)  
  * \+1 Skill XP each failed enemy’s attack  
  * (See Combat XP)  
* Magic (Access to higher powered spells)  
  * \+1% Mana used as Skill XP  
  * (See Combat XP)  
* Gathering (Gather rate)  
  * \+Skill XP equal to going rate of raw material in copper coins  
* Mining (Mining rate)  
  * \+Skill XP equal to going rate of raw material in copper coins  
* Intimidation (Intimidate during social encounters and get away with it)  
  * \+Skill XP equal to victim’s level  
* Deception (Deceive during social encounters and get away with it)  
  * \+Skill XP equal to victim’s level  
* Persuasion (Persuade during social encounters)  
  * \+Skill XP equal to victim’s level  
* Stealth (Ability to hide from other creatures)  
  * \+Skill XP equal to other creature’s perception level  
* Sleight of Hand (Theft)  
  * \+Skill XP equal to going rate of stolen item in copper coins  
* Performance (Ability to entertain)  
  * \+Skill XP equal to crowd’s total level  
* Perception (Ability to see stealthed creatures)  
  * \+Skill XP equal to other creature’s stealth level  
* Medicine (Ability to heal)  
  * \+1% healed HP as Skill XP  
  * (See Combat XP)  
* Investigation (Ability to find hidden objects)  
* Animal Handling (Ability to tame animals)  
  * \+Skill XP equal to 10% of the XP drop value of the animal  
* Athletics (Jumping stamina use/Climbing speed)  
* Acrobatics (Landing/Fall damage/Sprinting stamina use)  
* Crafting (Crafting rate)  
* Mechanics (Ability to craft advanced machines)  
* Leadership (Party size)  
  * (See Leadership)  
* Cooking  
* Fishing  
* Lock picking (Assassin/Engineer only)

Special Abilities (Chosen once every log\_2 levels):

* Alert (Indications for monsters/players near you)  
* Athlete (+1 to STR/DEX; faster to get up from prone)  
* Lucky (RNG is in your favor)  
* Natural Miner (+50% drop rate from mining)  
* Night Vision  
* Magic Sight  
* Partial class-locked ability

Reputation:

* With each faction/each character  
* Changed by interacting with faction  
* Completing quests offered by faction increases reputation  
* Failing quests offered by faction decreases reputation  
* Increasing reputation with enemy faction decreases reputation  
* Joining another faction adds that faction’s reputation to your reputation with this faction  
* Reputation provides a bonus/nerf to all skills when interacting with characters of the faction   
* Good reputation provides better quality quests  
* Bad reputation provides lower quality quests or none at all  
* Really bad reputation makes members of faction hostile on sight

Inventory:

* Items have weight, total carrying capacity based on strength.  Encumbered means can’t attack and 75% movement speed  
* Equipment:  
  * Head  
  * Chest  
  * Legs  
  * Feet  
  * Hands  
  * Finger (x8)  
  * Amulet  
  * Trinket (x2)  
  * Neck  
  * Wrist  
  * Waist  
  * Shoulders  
  * Backpack  
* Hotbar Selector:  
  * Main Hand  
  * Off Hand

## World

The world is procedurally generated, complete with settlements, NPCs, and quests.

Settlements belong to factions, NPCs belong to settlements (or free roam), quests are given by an NPC.

Regions have a difficulty level not more than two levels away from any bordering regions.

# Combat

* General  
  * Players can’t break blocks or interact with objects while holding a weapon, as the mouse buttons will be used for combat abilities.  
  * When switching to a weapon, a **1** second long animation will play and the weapon can’t be used until the animation finishes.  
  * Physical attacks deal more damage when targeted at a player’s head or creature’s weak spot, and decrease movement speed when targeted at a player’s legs or creature’s movement appendages (but deal slightly less damage).  
  * When the player takes damage from an attack, they will “flinch” and won’t take damage from attacks for **0.3** seconds. The player can’t attack or block while flinching, but can still dodge.  
  * Melee attacks have a swing animation of **0.3** seconds, which plays after the attack is actually inflicted. The player can’t attack again during the swing animation, but can still dodge.  
  * When the player takes damage from an attack, a directional damage indicator will appear, indicating the direction that the attack came from. The indicator adjusts to the player’s look direction dynamically and fades away over time, disappearing completely after **0.5** seconds. The indicator can indicate multiple damage directions at a time.  
  * While holding a melee weapon, the crosshair turns red when looking at a damageable entity that is within attack range.  
  * Damage numbers are displayed over the attacked entity, colored depending on damage type. Numbers show even when one’s attacks are blocked, or if the entity is immune (as “0”). Numbers greater than 999 are shortened and rounded to the nearest hundred when displayed. E.g., 2K, 1.6K  
* Combat state  
  * Players are in a “combat state” if they have attacked or been attacked less than **10** seconds ago.  
  * Players can’t assign abilities to their ability hotbar while in combat.  
  * Players can’t place blocks while in combat  
* Dodge  
  * Activate: Press left or right movement key and sprint key at about the same time, or press sprint key while holding left or right movement key. If the forward key is being held, the player will not dodge.  
  * Each dodge is either a left or right dodge and the player cannot move in the opposite direction of their dodge (relative to their look direction) while dodging.  
  * Dodge left and dodge right can be bound to dedicated keys.  
  * The player will move in the direction of the movement key pressed at a speed faster than strafing and a distinct dodging animation will play. The player can turn while dodging by moving the mouse left or right as if strafing normally. The forward and back movement keys will also move the player, but much slower than if the player was not dodging.  
  * Assassins move faster while dodging than other classes.  
  * All attacks inflicted on the player will “miss” or deal no damage during the duration of the dodge regardless of if the strike or projectile actually hit the player.  
  * Dodging lasts **0.3** seconds. If the sprint or direction key is released while dodging, the player’s movement will slow down but the player will remain dodging for the entire duration. Dodging cannot be canceled.  
  * Dodging should consume about **25%** of the player’s stamina.  
  * Dodging does not interrupt any attack. The player can attack while dodging.  
* Weapon weightheaviness  
  * Weapons have a weight heaviness attribute associated with them.  
  * Heavier weapons deal more damage, but with a tradeoff depending on the weapon type.  
  * This list describes the tradeoff of weight heaviness on each weapon type:  
    * Melee weapons (except daggers)  
      * Takes longer to charge  
    * Bows  
      * Takes longer to draw  
    * Crossbows  
      * Takes longer to “reload” (slower firing rate)  
    * Guns  
      * Slower firing rate (generally, heavier guns will have smaller magazines and/or slower reload times as well)  
  * Daggers have no weightheaviness.  
  * To keep things simple, there should only be three weight heaviness values, which should be displayed on the weapon.  
    * Light  
      * 0 seconds to full melee charge  
      * 0.4 seconds to full bow draw  
    * Medium  
      * 0.6 seconds to full melee charge  
      * 0.8 seconds to full bow draw  
      * 2x as much weapon damage as a light equivalent  
    * Heavy  
      * 0.9 seconds to full melee charge  
      * 1.2 seconds to full bow draw  
      * 3x as much weapon damage as a light equivalent  
  * Damage for medium and heavy melee weapons and all bows should be weapon damage multiplied by:0.2+0.8maxChargeTime3timeCharged3  
    * Starting at 0.2, reaches 1 at maxChargeTime at a rate of x^3  
    * Damage at 0 second charge is 20%  
    * Light weapons deal the same amount of damage regardless of charge. Charge for light weapons is used for shield break.  
    * Weapons deal considerably more damage at their max charge than a heavier weapon charged for the same amount of time  
    * Light, medium, and heavy equivalents of the same weapon all potentially deal the same damage per second.  
* Melee weapons (except daggers)  
  * Basic attack  
    * Activate: Press and hold left mouse button. A meter will fill at a rate specific to the weapon type being used. When LMB is released, the player attacks, dealing damage dependent on how much of the meter is full.  
    * For medium and heavy weapons, attack damage is determined by the formula above. For light weapons, the charge is only used for shield break, described below.  
    * If the player charges an attack for **0.9** seconds (same for all weapon heaviness) a visual indicator will appear over the charge meter to indicate that the attack is a “shield break” attack, and will cancel their target’s shield if they are blocking, deal full damage, and their target will be unable to block again for **1.5** seconds (even if they were not blocking when they were struck).  
    * Cancel: An attack can be canceled by pressing the right mouse button. A canceled attack does not consume stamina.  
    * A distinct animation plays when a player is charging an attack.  
    * Heavy weapons charge slowly but deal more damage. Medium weapons charge quickly but deal less damage.  
    * The player can charge an attack indefinitely, and no additional stamina will be drained for holding a charge.  
    * Movement is **0.7x** while charging an attack.  
    * Melee attacks should drain an amount of stamina dependent on weapon heaviness and charge percentage of the attack.  
  * Block (with Shield)  
    * Activate: Press and hold right mouse button (while not charging an attack)  
    * Deactivate: Release right mouse button.  
    * The player cannot attack, but can still dodge while blocking.  
    * A **0.1 (0.2)** second long animation will play to begin blocking. The player is not blocking until the animation finishes playing, and the block is canceled if the player is attacked during its animation.  
    * A **0.1 (0.2)** second long animation will play when the right mouse button is released to stop blocking. The player is not blocking but can’t attack during the animation, but can still dodge.  
    * If the player is attacked from the front while blocking, the blocker will not take any damage and will automatically stop blocking immediately (rather than waiting for the deactivate animation). If the attack was a melee swing, the attacker will be unable to attack, block, or dodge (but can still move) for **0.6 (1.2)** seconds.  
    * It costs **10%** stamina to begin blocking (even if it gets interrupted), and blocking drains stamina at **10%** per second (not including the start/stop animation time). Blocking halts stamina regen. The player stops blocking when the right mouse button is released, when they successfully block a melee attack, if they are hit by a shield break attack, or if they run out of stamina.  
    * Movement is **0.5x** while blocking.  
* Daggers (Assassin)  
  * Press left mouse button for basic instant attack  
  * Hold right mouse button to charge heavy attack (stab), similar to Melee attack for Heavy weapons above.  
    * Max charge at **0.9** seconds.  
    * Shield break effect applies at max charge  
    * For assassins, there is an ability on the ability hotbar (default: R) to cancel the attack.  
    * Switching items (unequipping the dagger) cancels the charge.  
    * **3x** weapon damage at max charge.  
    * Movement is not penalized for charging a heavy attack.  
* Spells  
  * TBD  
* Bows (Ranger)  
  * Hold right mouse button to zoom.  
  * Hold left mouse button to draw the bow, release to fire.  
  * For rangers, there is an ability on the ability hotbar (default: R) to cancel the draw.  
  * Switching items (unequipping the bow) cancels the draw.  
  * Time required for a full draw is dependent on weapon heaviness.  
  * Arrows fired before full draw is reached have slower starting velocity, hit the ground sooner, and deal less damage.  
  * Syringe darts  
    * Syringe darts are modifier abilities that are selected one at a time.  
    * To fire a syringe dart, it must be selected at the beginning of a draw. The player can deselect the syringe dart while drawing, but it will still be fired.  
    * When drawing a bow with a syringe dart, weapon heaviness is ignored. Max velocity is reached at the time required for a full draw for a light bow, but max potency & duration of **0.6x** is reached at the time required for a full draw for a heavy bow. The indicator for max charge should reflect that of a heavy bow.  
    * Firing a syringe dart makes a distinct sound distinguishable from the sound made from firing an arrow.  
    * When a syringe dart is blocked or hits a block (i.e: misses), it visibly shatters and a glass shatter sound is made.  
  * Potions that are not syringe darts can be used from the ability hotbar (and from the item hotbar, but that means unequipping the bow).  
  * Movement is dependent on weapon heaviness while drawing a bow.  
  * Crossbows are a ranger weapon that function like a single-shot gun that automatically reloads (Reload is an engineer ability only). See below.  
* Guns (Engineer)  
  * Hold right mouse button to zoom.  
  * Press left mouse button to fire.  
  * Automatically refires if left mouse button is being held.  
  * Firing rate is dependent on weapon heaviness.  
  * Recoil?  
  * Each weapon has its own magazine size and reload time.  
  * For engineers, there is an ability on the ability hotbar (default: R) to reload.  
* Damage Types (magical/mundane)  
  * Mundane  
    * Other  
      * Bleeding, falling, drowning, starving, things that don’t fit into any other damage type  
    * Piercing  
      * Daggers, rapiers, teeth, arrows, etc.  
    * Slashing  
      * Swords, claws, etc.  
    * Bludgeoning/Crushing  
      * Mace, hammers, etc.  
  * ???  
    * Color: red  
    * Big scary bosses  
  * Elemental  
    * Fire  
      * Color: orangered  
      * Spells, lava, enchanted weapons, elementals, dragons, etc.  
    * Cold  
      * Color: light blue  
      * Spells, cold biomes, enchanted weapons, elementals, dragons, etc.  
    * Lightning  
      * Color: blue  
      * Lightning, spells, enchanted weapons, elementals, dragons, tempest, etc.  
    * Acid  
      * Color: yellow  
      * Acid pits, traps, dragons, vials of acid, etc.  
    * Asphyxiation  
      *   
    * Poison  
      * Color: lime  
      * Poisons, traps, dragons, spells, etc.  
    * Necrotic  
      * Color: purple  
      * Undead, liches, vampires, spells, enchanted weapons, etc.  
    * Sonic  
      * Color: gray  
      * Thunder, explosions, spells, enchanted weapons, harpies, krakens, tempest, bard “singing”, etc.  
    * Psychic  
      * Color: pink  
      * Mind control, spells, enchanted weapons, psydragons, vicious mockery, etc.  
    * Radiant  
      * Color: white  
      * Desert biomes, spells, radioactivity, divine magic, etc.  
    * Dark  
      * Color: black  
      * Dark magicks, cultists, assassins, etc.  
    * Nature  
      * Color: green  
      * Druids  
    * Arcane  
      * Color: teal  
      * Magic, traps, etc.

# 

# Creatures

* Passive  
  * Rabbit \- Drops: Rabbit meat, rabbit pelt, rabbit’s foot  
  * Fox \- Drops: Fox pelt, snow  
  * Pig \- Drops: Pork  
  * Sheep \- Drops: Wool, lamb  
  * Cow \- Drops: Beef, cowhideleather  
  * Chicken \- Drops: Feathers, chicken  
  * Bird \- Drops: Feathers  
* Neutral  
  * Lion \- Drops: Lion pelt  
  * Tiger \- Drops: Tiger pelt  
  * Cat \- Drops: Curse of Nine Lives  
  * Deer \- Drops: Venison, deer pelt  
  * Dolphin \- Drops: Blubber  
  * Snake \- Drops: Snake meat, snake skin, snake eyes  
  * Dryad \- Drops: Leaves  
* Aggressive  
  * Zombie \- Drops: Rotten flesh, zombie head, cloth scraps  
  * Skeleton \- Drops: Bones, skull  
  * Giant Spider \- Drops: String, carapace, venom sac, spider eyes  
  * Naga \- Drops: Naga head  
  * Siren \- Drops: Siren scales  
  * Harpy \- Drops: Feathers, harpy talon  
  * Hag \- Drops: Potion ingredients  
  * Elemental (sub-types)  
  * Wyvern \- Drops: Wyvern hideleather, gold  
  * Drakes (sub-types) \- Drops: Drake hideleather, gold  
  * Ghoul \- Drops: Ghoul teeth  
  * Ghast \- Drops: Ghast tongue  
  * Ghost \- Drops: Ethereal crystal  
  * Poltergeist \- Drops: Incorporeal dust  
  * Specter \- Drops: Tincture of Hatred  
  * Wraith \- Drops: Ethereal crystal, Incorporeal dust, Tincture of Hatred, Soul Fragment  
  * Imp \- Drops: Imp hide, imp flesh  
  * Devil (sub-types)  
  * Demon (sub-types)  
  * Gnoll  
  * Hobgoblin  
  * Bugbear  
* Boss  
  * Kraken  
  * Leviathan  
  * Tempest  
  * Dragon (sub-types)  
  * Vampire  
  * Lich

# Blocks

* World Generation  
  * Rock  
    * Talc (Soft)  
    * Gypsum  
    * Calcite  
    * Limestone  
    * Sandstone  
    * Marble  
    * Apatite  
    * Basalt  
    * Obsidian  
    * Granite  
    * Rhyolite  
    * Diorite  
    * Andesite (Hard)  
    * Bedrock (Unbreakable)  
  * Dirt  
  * Grass  
  * Gravel  
  * Sand  
  * Water  
  * Lava  
  * Oil  
  * Log  
  * Clay  
  * Leyline  
* Mineables  
  * Ores  
    * Acanthite (Furnace: Silver, Grinder: 2 Silver \+ Sulfur)  
    * Barite (Furnace: Barium, Grinder: Barium \+ Sulfur)  
    * Bauxite (Furnace: Aluminum, Grinder: 2 Aluminum)  
    * Beryl (Grinder: 3 Beryllium \+ 2 Aluminum \+ 6 Silicon)  
    * Bornite (Furnace: Copper, Grinder: 5 Copper \+ Iron \+ 4 Sulfur)  
    * Cassiterite (Furnace: Tin)  
    * Chalcocite (Furnace: Copper, Grinder: 2 Copper \+ Sulfur)  
    * Chalcopyrite (Furnace: Iron, Grinder: Copper \+ Iron \+ 2 Sulfur)  
    * Chromite (Furnace: Chromium, Grinder: Iron \+ Magnesium \+ 2 Chromium)  
    * Cinnabar (Furnace: Mercury, Grinder: Mercury \+ Sulfur)  
    * Cobaltite (Furnace: Cobalt, Grinder: Cobalt \+ Iron \+ Arsenic \+ Sulfur)  
    * Coltan (Furnace: Iron, Grinder: Iron \+ Manganese \+ 2 Niobium \+ 2 Tantalum)  
    * Dolomite (Furnace: Calcium, Grinder: Calcium \+ Magnesium)  
    * Galena (Furnace: Lead, Grinder: Lead \+ Sulfur)  
    * Gold Ore (Furnace: Gold, Grinder: 2 Gold)  
    * Hematite (Furnace: Iron, Grinder: 2 Iron)  
    * Ilmenite (Furnace: Iron, Grinder: Iron \+ Titanium)  
    * Iridium Ore (Furnace: Iridium)  
    * Magnetite (Furnace: Iron, Grinder: 3 Iron)  
    * Malachite (Furnace: Copper, Grinder: 2 Copper)  
    * Molybdenite (Furnace: Molybdenum, Grinder: Molybdenum \+ 2 Sulfur)  
    * Pentlandite (Furnace: Nickel, Grinder: 9 Iron \+ 9 Nickel \+ 8 Sulfur)  
    * Pyrolusite (Furnace: Manganese)  
    * Scheelite (Furnace: Calcium, Grinder: Calcium \+ Tungsten)  
    * Sperrylite (Furnace: Platinum, Grinder: Platinum \+ 2 Arsenic)  
    * Sphalerite (Furnace: Zinc, Grinder: Zinc \+ Sulfur)  
    * Uraninite (Furnace: Uranium)  
    * Wolframite (Furnace: Iron, Grinder: Iron \+ Manganese \+ Tungsten)  
  * Gems  
    * Alexandrite  
    * Amethyst  
    * Aquamarine  
    * Citrine  
    * Diamond  
    * Emerald  
    * Garnet  
    * Jade  
    * Lapis Lazuli  
    * Moonstone  
    * Morganite  
    * Onyx  
    * Opal  
    * Pearls  
    * Peridot  
    * Rubellite  
    * Ruby  
    * Sapphire  
    * Spinel  
    * Tanzanite  
    * Topaz  
    * Tourmaline  
    * Turquoise  
    * Quartz  
    * Zircon  
* Craftable  
  * Planks  
  * Polished Stones  
* Machines  
  * Ore Processing  
    * Furnace  
    * Grinder  
  * Crafting  
    * Crafting Table  
    * Automated Crafting Table  
    * Coin Press  
  * Logistics  
    * Item Pipe  
    * Liquid Pipe  
    * Various Chests  
    * Various Tanks  
    * Storage Computer  
  * Logic  
    * Circuit Designer  
    * Integrated Circuit  
    * Circuit Wire  
  * Electric  
    * Coal Generator  
    * Pneumatic Generator  
    * Solar Panel  
  * Pneumatic  
    * Refinery  
    * Combustion Engine  
    * Electric Engine  
    * Etheric Engine  
  * Resource Management  
    * Automated Farming Unit  
    *   
  * World Interaction  
    * Piston  
    * Shield  
    * Vacuum Pipe  
    * Quarry  
    * Pump  
    *   
  * Interfaces  
    * Digital Market Adapter  
    * Digital Bank Adapter  
    * Wireless Storage Device  
    * Tesseract  
  * Teleportation  
    * Teleporter  
  * Ether  
    * Leyline Ether Tap  
    * Ether Pipe

# Playable Races

* Human  
  * Languages: Common \+ 2  
  * Size: Medium  
  * \+1% to all attributes  
* Elf  
  * Languages: Common, Elvish \+ 1  
  * Size: Medium  
  * \+1% DEX, \+1% MAG  
  * Magic Sight  
  * Slightly greater reputation gain  
* Dwarf  
  * Languages: Common, Dwarvish \+ 1  
  * Size: Small  
  * \+1% STR, \+1% CON  
  * Natural Miner  
  * Resistant to cold climates  
* Gnome  
  * Languages: Common, Gnomish \+ 1  
  * Size: Small  
  * \+1% DEX, \+1% CHA  
  * Lucky  
  * Larger map discover radius  
  * Food satiates more  
* Kobold  
  * Languages: Common, Draconic \+ 1  
  * Size: Small  
  * \+1% DEX, \+1% STA  
  * Long breath meter  
  * Night Vision  
  * Light Sensitivity  
  * Shorter aggro range for hostile enemies  
* Goblin  
  * Languages: Goblinoid \+ 2  
  * Size: Small  
  * \+1% STR, \+1% DEX  
  * Loots more money from corpses  
  * Resistant to hot climates  
* Orc  
  * Languages: Orcish \+ 2  
  * Size: Medium  
  * \+1% STR, \+1% STA  
  * Can consume corpses  
* Drow  
  * Languages: Common, Elvish \+ 1  
  * Size: Medium  
  * \+1% CHA, \+1% DEX  
  * Magic Sight  
  * Night Vision  
  * Light Sensitivity  
  * Faster health regeneration while out of combat  
* Construct  
  * Languages: 3  
  * Size: Medium  
  * \+1% STR, \+2% STA, \-1% CHA  
  * Does not need to No need to eat or drink or breathe  
  * Night Vision  
  * Cannot Unable to eat or drink  
  * Takes damage in water, rain  
  * Resistant to psychic damage  
* Felinian  
  * Languages: Common, Feline \+ 1  
  * Size: Medium  
  * \+1% DEX, \+1% CON  
  * Night Vision  
  * Lucky  
  * Fall damage is cappedTakes no fall damage  
  * Resistant to cold climates

# Classes

* Ranger  
  * Roles: Damage, Support  
  * \+25% DEX, STA  
  * \+25% XP: Fighting, Gathering, Acrobatics  
  * Medium Armor  
  * Abilities: TBD, **Potion Brewing**  
* Warrior  
  * Roles: Tank, Damage  
  * \+25% STR, CON  
  * \+25% XP: Fighting, Survival, Athletics  
  * Heavy Armor  
  * Abilities: TBD, **Warcrafting**  
* Cleric  
  * Roles: Support  
  * \+25% CON, MAG  
  * \+50% XP: Medicine; \+25% XP: Magic  
  * Medium Armor  
  * Abilities: Divine Magic, **Divine Rituals**  
* Engineer  
  * Roles: Damage, Support  
  * \+25% STA, MAG  
  * \+25% XP: Crafting, Mechanics, Investigation  
  * Light Armor  
  * Abilities: TBD, Lock picking, **Golemancy**  
* Druid  
  * Roles: Tank, Damage, Support  
  * \+25% DEX, MAG  
  * \+25% XP: Animal Handling, Survival, Perception  
  * Light Armor  
  * Abilities: Nature Magic, **Animal Shape**  
* Sorcerer  
  * Roles: Damage, Support  
  * \+25% CHA, MAG  
  * \+75% XP: Magic  
  * No Armor  
  * Abilities: Arcane Magic, Sorcerous Magic, **Casting Manipulation, Familiar**  
* Warlock  
  * Roles: Damage, Support Support (Hexes, debuffs, etc.)  
  * \+25% CON, MAG  
  * \+25% XP: Magic, Survival, Intimidation  
  * Medium Armor  
  * Abilities: Arcane Magic, Eldritch Magic, **Patron Features**, Warlock Sword, Necromancy  
* Wizard  
  * Roles: Damage, Support  
  * \+25% STA, MAG  
  * \+50% XP: Magic; \+25% XP: Investigation  
  * No Armor  
  * Abilities: Arcane Magic, Sorcerous Magic, Wizard Magic, **Rune Crafting**  
* Paladin  
  * Roles: Tank, Damage, Support  
  * \+25% STR, CON  
  * \+25% XP: Fighting, Survival, Athletics  
  * Heavy Armor  
  * Abilities: Divine Magic  
* Bard  
  * Roles: Support  
  * \+25% CHA, DEX  
  * \+25% XP: Intimidation, Deception, Persuasion, Performance  
  * No Armor  
  * Abilities: Arcane Magic, **Music Crafting**  
* Monk  
  * Roles: Damage, Support  
  * \+25% STR, DEX, STA  
  * \+25% XP: Fighting, Survival, Acrobatics  
  * No Armor  
  * Abilities: Martial Arts, TBD  
* Assassin  
  * Roles: Damage  
  * \+25% DEX, STA  
  * \+25% XP: Stealth, Sleight of Hand, Deception, Investigation  
  * Light Armor  
  * Abilities: TBD, Lock Picking, **Traps**

# Abilities

* Divine Magic  
  * Access to the Divine spell list  
* Nature Magic  
  * Access to the Nature spell list  
* Animal Shape  
  * Can take the form of an animal  
* Arcane Magic  
  * Access to the Arcane spell list  
* Sorcerous Magic  
  * Access to the Sorcerer spell list  
* Casting Manipulation  
  * Ability to expend more mana to manipulate the casting:  
    * Instant cast  
    * Empowered cast  
    * Doubled cast  
    * Stealth cast  
* Eldritch Magic  
  * Access to the Eldritch spell list  
* Patron Features  
  * Choose log\_2(level) of:  
    * TBD  
* Wizard Magic  
  * Access to the Wizard spell list  
* Rune Crafting  
  * Ability to deconstruct spells/items to learn runes  
  * Ability to invent new spells with known runes  
  * Ability to enchant items with known runes  
* Light Sensitivity  
  * High light levels hinder visibility  
  * Washed out as opposed to dark  
  * Similar stealth mechanics in light as there are in dark  
* Night Vision  
  * Can see as well without light as a normal character can see in normal light  
  * Negates dark stealth advantage

#  Magic

Magic is written in the language of runes.  The language is reproduced below:  
```
<spell>         ::= <trigger> <paragraph>
<trigger>       ::= CAST_RUNE
                  | DEATH_RUNE
                  | PERSIST_RUNE
                  | PROXIMITY_RUNE
                  | DAMAGE_RUNE
<paragraph>     ::= <sentence>
                  | <sentence> COMBINING_RUNE <paragraph>
<sentence>      ::= <target-clause> <action-clause>
<target-clause> ::= SELF_RUNE
                  | TOUCH_RUNE
                  | RANGE_RUNE <range>
                  | BOUND_RUNE
<range>         ::= /* empty */
                  | DISTANCE_RUNE <range>
<action-clause> ::= <effect-clause> <action>
<effect-clause> ::= LINE_RUNE
                  | CONE_RUNE
                  | AREA_RUNE <area-clause>
<area-clause>   ::= <area-type> <ref-point> <area>
<area-type>     ::= SPHERE_RUNE
                  | COLUMN_RUNE
                  | CUBE_RUNE
<ref-point>     ::= CLOSE_RUNE
                  | FAR_RUNE
                  | CENTER_RUNE
<area>          ::= /* empty */
                  | AREA_RUNE <area>
<action>        ::= EFFECT_RUNE <duration> <effect-type>
                  | DAMAGE_RUNE <damage-type> <power>
                  | HEALING_RUNE <power>
                  | DIG_RUNE
                  | TELEPORT_RUNE <destination>
                  | BIND_RUNE
<duration>      ::= DURATION_RUNE
                  | DURATION_RUNE <duration>
<effect-type>   ::= DAMAGE_RUNE <damage-type> <power>
                  | EYES_RUNE
                  | HEALING_RUNE <power>
                  | LANGUAGE_RUNE
                  | JUMPING_RUNE
                  | SPEED_RUNE <power>
                  | SLOW_RUNE <power>
                  | CHARM_RUNE
                  | LIGHT_RUNE
<damage-type>   ::= FIRE_RUNE
                  | COLD_RUNE
                  | NECROTIC_RUNE
                  | RADIANT_RUNE
                  | LIGHTNING_RUNE
                  | SONIC_RUNE
                  | NATURE_RUNE
                  | PSYCHIC_RUNE
                  | POISON_RUNE
                  | ACID_RUNE
                  | ARCANE_RUNE
                  | DARK_RUNE
<power>         ::= /* empty */
                  | POWER_RUNE <power>
<destination>   ::= RANGE_RUNE <range>
                  | BOUND_RUNE
```

## Spell Lists

* Basic \- Available to all  
  * Touch Dig \- CAST\_RUNE TOUCH\_RUNE AREA\_RUNE CUBE\_RUNE CLOSE\_RUNE DIG\_RUNE  
  * Flame Hand \- CAST\_RUNE TOUCH\_RUNE AREA\_RUNE CUBE\_RUNE CLOSE\_RUNE DAMAGE\_RUNE FIRE\_RUNE  
* Divine  
  * Heavenly Strike \- CAST\_RUNE RANGE\_RUNE DISTANCE\_RUNE DISTANCE\_RUNE DISTANCE\_RUNE DISTANCE\_RUNE AREA\_RUNE COLUMN\_RUNE CENTER\_RUNE AREA\_RUNE AREA\_RUNE DAMAGE\_RUNE RADIANT\_RUNE POWER\_RUNE POWER\_RUNE POWER\_RUNE POWER\_RUNE

# 

# Potion Brewing

Potions require:

* A base liquid which determines the potency  
* A matched monster and herbal component which decides the effect  
* A binding agent which determines the duration  
* An optional corrupting agent which inverts the effect  
* An optional combinator allowing additional effects to be applied  
  * Each additional effect has 60% potency of the previous effect.  
* A catalyst which determines activation time  
* (optional) A color additive which determines the icon and particle effect color  
  * If omitted, the potion color is determined by the effect  
* A container which determines delivery

Ingredients:

* Bases  
  * Water (1.0x)  
  * Blood (1.52x)  
  * Ritual Blood (2.5x)  
  * Purified water (2.0x)  
  * Holy water (2.5x)  
  * Unicorn Blood (3x)  
* Effects  
  * Monster  
    * Venom sac (poison/regeneration)  
    * Rotten flesh (disease/restoration)  
    * Bones (strength/weakness)  
    * Spider eyes (true sight/blindness)  
    * Ghast tongue (mana/mana-drain)  
    * ??? (stamina/stamina-drain)  
    * Tincture of Hatred (damage/healing)  
    * Incorporeal dust (invisibility/glowing)  
    * Rabbit’s foot (jumping/earth-bound)  
    * ??? (speed/slow)  
    * ??? (resistance/vulnerability)  
  * Herbs  
    * Lavender (poison/regeneration, true sight/blindness)  
    * Basil (disease/restoration, mana/mana-drain, stamina/stamina-drain)  
    * Dill (strength/weakness, invisibility/glowing)  
    * Rosemary (jumping/earth-bound, speed/slow)  
    * CilantroOregano (Poison damage type)  
    * Spearmint (Cold damage type)  
    * Sage (Psychic damage type)  
    * Hemp (Radiant damage type)  
      * https://www.leaf.tv/articles/natural-alternatives-for-synthroid/  
    * Nightshade (Necrotic damage type)  
    * Aloe (Fire damage type)  
    * Rubber (Lightning damage type)  
* Binding Agents  
  * Salt (1.0x)  
  * Calcium Dust (1.5x)  
  * Topaz Dust (2.0x)  
  * Onyx Dust (2.5x)  
  * Diamond Dust (3.0x)  
* Corrupting Agents  
  * Ethereal dust  
  * Snake meat  
* Combinators  
  * Leaves (1 additional)  
  * Caveroot (2 additional)  
  * Sunstone (3 additional)  
* Catalysts  
  * Dirt (1x)  
  * Grass (0.5x)  
  * Earth Essence (0.25x)  
  * Water Essence (Instant)  
* Color additives  
  * Any dye  
* Containers   
  All potions are brewed in a vial.  All containers except the vial are consumed on use.  
  * Vial  
    * Used on self  
    * Empty vial is crafted with glass  
    * Takes 2 seconds to use  
    * Usable by anyone  
  * Syringe  
    * Used on other creatures within close proximity  
    * Crafted with vial, bee stinger (farmable bees)  
    * Takes 2 seconds to use  
    * Usable by anyone with Potion Brewing  
  * Weighted vial  
    * Used on an area  
    * 0.5x potency & duration to affected creatures  
    * Crafted with vial, stone  
    * Takes 0.3-0.5 seconds to throw  
    * Usable by anyone  
  * Syringe dart  
    * Used on creature that is hit  
    * Crafted with arrow, syringe  
    * Potency & duration dependent on charge time, described under Combat.  
    * Deals no damage (outside of potion effect)  
    * Uses bow mechanics  
    * Usable by rangers

# Warcrafting

Warcrafting is the art of crafting implements of war.  This includes what would traditionally be called blacksmithing, leatherworking, bowing, and woodworking for the purposes of making armor, shields, and weapons.  While most people stick with simple iron weapons and leather armor, you have learned to customize the materials used to make weapons and armor, making them both more flexible and more powerful.

You have also learned how to make improvements to weapons and armor that have seen a lot of use when you repair them.

You may also use what you’ve learned to improve other non-combat tools as well.

* This gives you access to the Arms Workbench, Anvil, Smeltery, and Casting Tables.  
* Weapons  
  * Broadsword (Large Blade, Standard Guard, Basic Rod)  
  * Longsword (Large Blade, Hand Guard, Basic Rod)  
  * Rapier (Large Blade, Small Guard, Basic Rod)  
  * Dagger (Small Blade, Small Guard, Basic Rod)  
  * Shortbow (1 Basic Rod, Bowstring)  
  * Longbow (1 Advanced Rod, Bowstring)  
  * Arrows (Arrow Head, Basic Rod, Fletching)  
  * Cutlass (Large Blade, Full Guard, Basic Rod)  
  * Warhammer (Hammer Head, Advanced Rod)  
  * Scythe (Scythe Head, Tough Binding, 2 Basic Rod)  
  * Cleaver (Large Blade, Plate, 2 Advanced Rod)  
  * Battleaxe (2 Broad Axe Head, Tough Binding, Advanced Rod)  
* Armor  
  * TBD  
* Tools  
  * Pickaxe (Pickaxe Head, Binding, Basic Rod)  
  * Shovel (Shovel Head, Basic Rod)  
  * Hatchet (Axe Head, Basic Rod)  
  * Mattock (Axe Head, Shovel Head, Basic Rod)  
* Levels  
  * Items crafted by a warcrafter gain XP as they are used.  Each level new level of the tool allows a warcrafter to add an additional modifiers to the item.  
* Modifiers  
  * TBD

# Golemancy

Golems are clockwork machines that can do basic tasks such as fighting, defending, carrying, etc.  The ancient knowledge of golemancy is well-protected by the engineering guild.

All of the golem parts are crafted independently, and then the golem is assembled from the parts.  Golems can run on electricity or ether.

Golems require, at minimum:

* Exactly two or four legs, or one-four wheels  
* Core Shell  
* Energy Adapter  
* Energy Storage  
* Intelligence Imitator

Golems can also have:

* Up to two arms  
* Shield Generator  
* Crafting Chamber  
* Mana Binding Crystal  
* Weapons and tools

# Divine Rituals

# Animal Shape

When you kill an animal, you may take the time to bond with its soul.  This grants you the ability to transform into an animal of that form, assuming that you are at least three times its base level.  When you transform into an animal form, you gain all of the attributes of that animal, including its health, mana, and stamina pools as well as any abilities.  You also lose access to your health and stamina pools as well as any abilities.  You retain the ability to see your mana pool, but unable to do anything with it other than maintain or cancel the animal shape.

However, the level of the animal you transform into will initially be at its base level.  Any XP gained in the animal shape will go to that animal shape, rather than to your character, if your level is greater than three times the current level of the animal shape.  The animal shape will level up as it gains XP.

When the animal shape dies, you will revert back to your character’s form, taking any damage in excess of the necessary damage to kill the animal shape to your character’s health pool.  Your character’s mana pool is used to cast, and then maintain the animal shape.  If your character’s mana pool runs out of mana, your animal shape will drop.  You may also drop your animal shape at will.

Animal shape XP is stored per shape, not per casting, so if you level up your snake animal shape, each time you transform into your snake animal shape, you will start wherever you left off XP-wise.  However, if you transform into a tiger for the first time, you will start at the base level of tigers, and any XP you gain in tiger form will not apply to your snake form.

# 

# Settlements

A settlement is a location where NPCs live.  At minimum, a settlement has two buildings and two NPCs.  Settlements have a mana pool, which can be used to cast settlement-wide spells.  The mana pool regenerates at a rate equal to it’s mana pool per day.  
Settlements are categorized by size:

* Isolated Dwelling  
  * Available  
    * Hamlet Center  
    * House  
    * Longhouse  
* Hamlet  
  * Population \>= 10  
  * Buildings \>= 4  
  * Mana Pool: 1,000  
  * Required  
    * Hamlet Center  
  * Available  
    * Village Center  
    * Tavern  
    * Graveyard  
    * Farm  
* Village  
  * Population \>= 50  
  * Buildings \>= 10  
  * Mana Pool: 5,000  
  * Required  
    * Village Center  
    * Graveyard  
  * Available  
    * Town Center  
    * Trading Post  
    * General Store  
    * Workshop  
    * Forge  
    * Vault  
    * Bank  
    * Warehouse  
    * Inn  
    * Walls  
* Town  
  * Population \>= 200  
  * Buildings \>= 30  
  * Mana Pool: 10,000  
  * Required  
    * Town Center  
    * Trading Post  
    * Walls  
  * Available  
    * City Center  
    * Foundry  
    * Post Office  
    * Clinic  
    * Temple  
    * Guard Station  
    * Docks  
* City  
  * Population \>= 1,000  
  * Buildings \>= 70  
  * Mana Pool: 50,000  
  * Required  
    * City Center  
    * Post Office  
    * Guard Station  
  * Available  
    * Capitol  
    * Shop  
    * School  
    * Hospital  
    * Ether Rail Station  
    * Seaport  
    * Portal  
* Metropolis  
  * Population \>= 10,000  
  * Buildings \>= 500  
  * Mana Pool: 1,000,000  
  * Required  
    * Capitol  
    * School  
    * Hospital  
  * Available  
    * Ether Rail Hub  
    * Airship Dock  
    * Portal Hub

Settlements have buildings:

* House  
* Longhouse  
* Hamlet/Village/Town/City Center/Capitol  
* Trading Post  
* Tavern  
* General Store  
* Workshop  
  * Woodworking Annex  
  * Enchanting Annex  
  * Engineering Annex  
* Forge/Foundry  
* Post Office  
* Bank  
* Clinic/Hospital  
* Vault  
* Warehouse  
* Inn  
* Temple  
* Graveyard  
  * Respawn point  
* Shop  
  * Magic  
  * Etc.  
* School  
* Farm  
* Guard Station  
* Docks/Seaport  
* Ether Rail Station  
* Ether Rail Hub  
* Airship Dock  
* Portal  
* Portal Hub

# 

# Dungeons

Dungeons are dangerous pocket planes with entrances in the prime plane.  Imbued with magic, a dungeon is an evolving labyrinth intent on luring characters to their demise with promises of treasure, fame, and renown.  Each dungeon has a boss monster whose level is based on the level of the dungeon.

Dungeons have a mana pool that is used to reconfigure themselves, purchase new rooms, spawn monsters, and respawn boss monsters.  This mana pool regenerates continuously over the period of one in-game day.

Most dungeons are not owned, however if the entrance to an unowned dungeon is within the area of influence of a town or larger settlement, and the leader of the settlement leads a dungeon party that vanquishes the dungeon, the leader may claim the title of Dungeon Keeper.  A Dungeon Keeper may change or prioritize how a dungeon spends its mana, as well as sacrificing items or creatures to the dungeon to teach it about the items.

Dungeons gain XP from all combat that happens inside the dungeon, and level up.  When a dungeon levels up, it’s mana pool increases.

Dungeons have rooms that provide certain boons to the dungeon.  The total mana cost of the rooms and traps combined cannot exceed five times the mana pool size.  Rooms:

* Lair  
  * Mini-boss room  
  * Grants access to lesser boss monsters  
  * 1,000MP to create  
* Hallway  
  * Connects rooms  
  * 10MP to create  
* Monster Room  
  * Contains monsters  
  * 50MP to create  
* Armory  
  * Allows monsters to use weapons and armor  
  * 100MP to create  
* Treasury  
  * Any death or other drops from a non-dungeon creature within the dungeon will be claimed when the dungeon is empty by the dungeon and converted into mana, loot, or XP for the dungeon.  
  * 500MP to create  
* Summoning Room  
  * Allows the dungeon to spawn monsters for free in the room so long as the summoning circle is intact and as long as the sum of levels of monsters spawned from this room at any given time never exceeds five times the dungeon’s level.  
  * 1,000MP to create  
* Alchemical laboratory  
  * Allows the dungeon to spawn monsters with potions and use potions in traps.  
  * 2,000MP to create  
* Wizard’s Study  
  * Allows the dungeon to spawn monsters with enchanted weapons   
  * Requires: Armory  
  * 2,000MP to create  
* Sorcerer’s Place of Power  
  * Allows the dungeon to spawn monsters that are spellcasters  
  * 2,000MP to create  
* Warlock’s Necromantic Shrine  
  * Allows the dungeon to raise recently dead monsters as undead  
  * 2,000MP to create  
  * 10% Spawn MP to raise as undead

Traps:

* Drop Pit  
  * 2x2  
  * 10 block drop  
  * 20MP to create  
* Drop Pit w/Spikes  
  * 2x2  
  * 10 block drop  
  * Spikes at bottom  
  * 40MP to create  
* Arrow Trap  
  * 2x2  
  * Upon stepping on trigger, arrows begin flying for 15 seconds  
  * 50MP to create  
* Alarmed Door  
  * Door  
  * Upon opening door, alarm sounds, and all nearby monsters aggro  
  * 60MP to create

Monsters: Cost 50MP for each level

# Combat XP

A dead entity’s XP is distributed proportionally to all characters involved in the combat by adding up all incoming damage and outgoing damage for the dead entity, as well as healing to the characters in the combat session since the beginning of it’s combat session.

A combat session starts when the entity is damaged by or aggros on a character.  A combat session resets when the entity is no longer in an aggro state and its resource pools are full.

A character’s share of the dead entity’s XP is calculated by taking the dead entity’s XP drop value divided by the total number of hitpoints of damage taken and given by the dead entity, then multiplied by the total number of hitpoints of damage taken and given between the dead entity and the character. (The more damage you give or receive from the monster, the more XP you get)

The XP is divided into five categories based on what type of damage was contributed:

* XP from hits (fighting)  
* XP from magic damage (magic)  
* XP from tanking/receiving damage (survival)  
* XP from other damage sources (other)  
* XP from healing (medicine)

If the character is a member of a party, the XP is instead delivered to the party for distribution by the party mechanic.

When the XP is distributed to the character, if the character is a higher level than the dead entity, then a level difference penalty (-10% per level) is applied to the XP gained. Finally, the XP is distributed through the appropriate skill (fighting, magic, survival) or just directly into the character’s XP pool (other).

XP is distributed to all characters involved in the dead entity’s combat session, regardless of whether they died in the past.

# 

# Leadership

Leadership is a bit unlike most of the skills.  When you form a group, the leader can choose to devote a percentage of their share of XP to leadership XP.  This is the only way to level up the Leadership skill.  Each level of Leadership grants 1 Leadership Point.  Leadership Points can be spent to grant boons to everyone in a party led by a player who has purchased a boon.

* Increased Party Health Regeneration (+2/sec per point)  
* Increased Mana Regeneration (+2/sec per point)  
* Increased Stamina Regeneration (+2/sec per point)  
* Increased Movement (+2% per point)

# Achievements

Achievements are fun, eclectic, often whimsical mini-quests with primarily vanity rewards, with minor amounts of XP.

# Milestones

Milestones are essentially secret quests, complete with generous XP and item rewards.

# Marks

A mark is a permanent boon or curse on a character. Usually earned through one-of-a-kind events.

# Badges

A badge is a temporary boon or curse based on some form of ranking.  For example, \#1 by total XP.

# Prompts

Prompts are requests for user input.  All prompts have an expiration after which the prompt is automatically declined (if possible) or an option is chosen at random.

# Factions

## Empire (or solo Kingdom)

Has many kingdoms (and thus settlements) who have sworn allegiance.  
Has many guilds that were ordained by the Empire.  
Has many clans.

## Guilds

A guild is a group of NPCs that share a similar interest.  For example, Thieves’ guild of Ara, Engineering guild of Ara, Traders’ guild of Ara

Consider: Allowing players to “join” or “ally with” a guild.

## Tribe

A tribe is precursor to a clan created by a player for players to provide leadership and organization for a group of players. Players can only belong to one group at a time.  A tribe cannot have more than 20 players.

## Clans

A tribe can be converted into a clan by pledging allegiance to a king or emperor, after gaining X relationship with the kingdom or empire.  A clan also has access to a shared clan treasury and the ability to own castles and other forms of land and buildings.  Clans can’t be disbanded unless everyone leaves.  Leadership moves to the next designated leader if a leader leaves, if no next designated leader exists, a general vote will determine the next leader.

Clan leadership will be pruned for inactivity after 1 month.  Membership can be pruned if leadership desires.

## Settlements

See “Settlements” above

## Kingdom

A Kingdom is an allegiance of settlements ruled by a ruler.

# Quests

* Quests are given by NPCs depending on settlement needs, the player’s level, and the NPC’s role in their settlement.  
* NPCs with an available quest are marked with a “\!” over their heads, colored depending on quest type (normal, group, pvp).  
* NPCs with an accepted quest are marked with a “?” over their heads, colored depending on quest status (completed, uncompleted)  
* Most (all?) quests have a timer that indicates how long the player has to complete the quest before it is automatically removed from the quest log. The timer is visible on each quest in the quest log.  
* Most quests have indicators for the quest objective location, which are visible on the player’s map and compass (if the objective is close enough).  
* Quests are automatically removed from the quest log if the timer expires, if the quest giver dies, if the quest giver’s reputation becomes hostile with the player, or if the quest is failed (for quests with a lose condition).

## Settlement Quests

* Retrieve resources  
  * Give an amount of a resource like wood or stone  
  * Does not reward experience  
* NPC Bounties  
  * Defeat a number of enemies or one difficult enemy  
* Player Bounties  
  * Defeat a player  
  * Marked as a pvp quest  
  * Quest indicator marks is most recent spotting by an NPC of the same settlement.  
  * Quest is only given if the player has been seen by an NPC of the settlement very recently and the target player is nearby  
  * Quest timer is relatively short (but can still be turned in after it ends if the target player has been defeated)  
  * Quest difficulty indicator is based on the level of the target player and the quest is not given if the target player’s level is too high  
* Retrieve stolen item  
  * Search enemy hideout for chest containing a quest item  
* Destroy enemy creature hideout  
  * Destroy an amount of blocks in an enemy hideout (probably with fire, on structures consisting of wood or otherwise flammable blocks)  
* Construct/repair a settlement building  
  * Construct a building according to a blueprint.  
* Find/rescue missing creature(s)  
  * Search for a creature gone missing in a location and return them  
  * Quest is failed if the creature dies  
* Escort creature(s)  
  * A creature is travelling from one location to another.  Protect them.  
  * Quest is failed if the creature dies  
* Vanquish a dungeon  
  * Defeat the boss of a dungeon  
  * Marked as a group quest  
  * If this quest is given to the settlement leader and the dungeon is within the settlement’s area of influence, they will reap higher quest rewards if the dungeon is claimed. This is still the same quest, and can be shared with other players as a standard “Vanquish a dungeon” quest  
* Aid  
  * Complete quests for another friendly settlement.  
  * Quest is more likely to be given following an attack on a friendly settlement.  
  * Can be turned in to either the quest giver or another NPC in the settlement in question.  
  * If the player is a relatively high level, this quest will be given for a settlement in a higher level zone and the quest difficulty color will match that of said zone.  
* Diplomatic  
  * Improve reputation between two factions  
* Political  
  * Raise your own reputation  
  * Reward: ability to join a settlement, ability to lead a settlement

## Kingdom Quests

* Defend settlement  
* Attack settlement

#  

# Pantheon

Members of the Pantheon (deities) are not entities in Runetide, but are AI that generate quests for those that follow them.  Deities have a repository of Divine Points. Divine Points can be spent to buff or debuff creatures, spawn creatures, protect regions, kill creatures, or spawn their avatar (from cheapest to most expensive).  A special NPC controller will decide how and when these are used to advance their goals.

Deities also provide for a natural way for game moderation/administration to shape game-wide events.

* Gods of the Core Domains  
  * Can be followed by characters  
  * Gains divine points every day that a character that follows them logs in or when one of their quests is completed  
  *   
  * Ithos, God of Civilization  
    * Enemies: Dahphine, Xerena  
    * Plane: The Eternal City of Oxonoth  
    * Boon: \+2% XP Leadership  
  * Kotyx, God of Life  
    * Enemies: Atix, Yankiildrux, Thodis  
    * Plane: The Radiant Islands of Raix  
    * Boon: \+2% XP Medicine  
  * Matrix, God of Order  
    * Enemies: Xerena, Dimmog  
    * Plane: The Mountains of Runos  
    * Boon: \+2% XP Persuasion  
  * Vahsin, God of Secrets  
    * Enemies: Iuna, Eos  
    * Plane: The Twisted Caves of Pisos  
    * Boon: \+2% XP Deception  
  * Thodis, God of War  
    * Enemies: Umena, Kotyx  
    * Plane: The Twin Empires of Xex  
    * Boon: \+2% XP Fighting  
  * Xomlios, God of Darkness  
    * Enemies: Eos, Iuna  
    * Plane: The Shadow Realms of Turiz  
    * Boon: \+2% XP Stealth  
  * Rhitarr, God of Fate  
    * Enemies: Itia, Xerena  
    * Plane: The Beaches of Mezal  
    * Boon: \+2% XP Survival  
  * Tanir, God of Technology  
    * Enemies: Nudarae, Zytrix  
    * Plane: The Mechanical City of Bronze  
    * Boon: \+2% XP Mechanics  
  * Eos, Goddess of Light  
    * Enemies: Vahsin, Xomlios  
    * Plane: The Radiant Islands of Raix  
    * Boon: \+2% XP Perception  
  * Xerena, Goddess of Chaos  
    * Enemies: Ithos, Matrix, Rhitarr  
    * Plane: The Twisted Caves of Pisos  
    * Boon: \+2% XP Sleight of Hand  
  * Dahphine, Goddess of Nature  
    * Enemies: Ithos, Yankiildrux, Dimmog  
    * Plane: The Magical Forest of Fyavaanyl  
    * Boon: \+2% XP Animal Handling  
  * Iuna, Goddess of Knowledge  
    * Enemies: Vahsin, Xomlios  
    * Plane: The Eternal City of Oxonoth  
    * Boon: \+2% XP Investigation  
  * Atix, Goddess of Death  
    * Enemies: Yankiildrux, Kotyx  
    * Plane: The Shadow Realms of Turiz  
    * Boon: \+2% XP Intimidation  
  * Umena, Goddess of Peace  
    * Enemies: Thodis, Zytrix  
    * Plane: The Beaches of Mezal  
    * Boon: \+2% XP Performance  
  * Itia, Goddess of Choice  
    * Enemies: Rhitarr, Xyta  
    * Plane: The Mountains of Runos  
    * Boon: \+2% RNG  
  * Nudarae, Goddess of Magic  
    * Enemies: Tanir, Demogorgon  
    * Plane: The Magical Forest of Fyavaanyl  
    * Boon: \+2% XP Magic  
* Exiled Gods  
  * Cannot be followed by characters  
  * Gains a fixed number of Divine Points per day  
  * Dimmog, God of Corruption  
    * Enemies: The Prime Plane  
    * Plane: Erebus (of the Abyss)  
  * Udon, God of Monsters  
    * Enemies: Intelligence  
    * Plane: Acheron (of the Hells)  
  * Yankiildrux, God of Undeath  
    * Enemies: Life  
    * Plane: Moorsheim (of the Abyss)  
  * Zytrix, Goddess of Destruction  
    * Enemies: Nature, Civilization  
    * Plane: Hades (of the Hells)  
  * Nielia, Goddess of Pestilence  
    * Enemies: All Life  
    * Plane: Gehenna (of the Hells)  
  * Xyta, Goddess of the Damned  
    * Enemies: Players  
    * Plane: Tartarus (of the Hells)  
* Ascended Beings  
  * Tiamat, Queen of Dragons  
    * Enemies: Non-dragons  
    * Plane: Sheol (of the Abyss)  
  * Demogorgon, Prince of Demons  
    * Enemies: Non-demons  
    * Plane: Abaddon (of the Abyss)  
  * Omega, The Prime Elemental  
    * Enemies: None  
  * Braz’rukaan, Lord of Avernus  
    * Enemies: Non-devils  
    * Plane: Avernus (of the Hells)  
  * Nalini, Keeper of the Underworld  
    * Enemies: Undead  
    * Plane: The Underworld

# Planes/Worlds/Dimensions

The multiverse consistsis comprised of multiple dimensions or planes.  The planes, while similar to Minecraft’s dimensions (overworld, nether, the end), are generally more varied and more diverse than Minecraft’s dimensions.  Some planes are unique in the multiverse, and others are more categorized as a class of similar planes.  For example, a dungeon has its own pocket plane that, while similar to other dungeon planes, is separate from other dungeon planes \-- that is, you could not walk from one dungeon to another from within the dungeon’s plane.

## Prime

The Prime Plane is the default spawn of a multiverse.  It contains everything one would think of as the “overworld.”

## The Near Realms

### Underworld

The Underworld is the interstitial where characters go for respawn.  A dark sky with no light spreads over an expansive wasteland of ruins stretching in every direction.  Skeletons are native to this plane.  Living creatures that make their way here quickly die from a strong withering debuff.

### The Deep

Filled with valuable ores, this cavernous dimension is home to strange aberrant thieving creatures, intent on your valuables.  Entrances can be found at the deepest depths of the Prime Plane, but enter at your own risk.

### Dungeons

(See Dungeons above)

Dungeons create their own pocket dimension that is separate from the Prime Plane, even though they have entrances in the Prime Plane.

### The Maze

The Maze is a vast, interconnected network with portals to every dungeon spread out among a vast labyrinth of unmineable walls.  High-level monsters roam the maze freely.

## The Elemental Planes

### Elemental Plane of Water

The Elemental Plane of Water is an ocean that stretches in all directions.  Filled with aquatic life and submarine aquatic civilization.  Access via portals found in the deepest depths of the oceans of the Prime Plane.

### Elemental Plane of Fire

The Elemental Plane of Fire is a lake of lava and fire with no discernible features above the surface.  Filled with creatures immune to fire.  Access via portals found in the largest lakes of lava on the Prime Plane.

### Elemental Plane of Earth

### Elemental Air PlanePlane of Air

## The Far Realms

### The Eternal City of Oxonoth

### The Radiant Islands of Raix

### The Mountains of Runos

### The Twisted Caves of Pisos

### The Twin Empires of Xex

### The Shadow Realms of Turiz

### The Beaches of Mezal

### The Mechanical City of Bronze

### The Magical Forest of Fyavaanyl

## The Five Hells

### Acheron

### Hades

### Gehenna

### Tartarus

### Avernus

## The Endless Layers of The Abyss

### The Void

(Nothingness)

### Erebus

(Chaos)

### Moorsheim

(Undead and such)

### Sheol

### Abaddon

# 

# 

# Names

* Cube-themed  
  * Cuboids  
  * Immortal Cubes  
  * **Project Cuboid**  
    * **Elgenzay:**  
      * **Originality: 1/5**  
      * **Coolness: 5/5**  
      * **Shortenings: “Cuboid”**  
  * **VoxelRealms**  
    * **Elgenzay:**  
      * **Originality: 3/5**  
      * **Coolness: 4/5**  
      * **Shortenings: “Voxel”**  
  * **Kingdom³**  
    * **Elgenzay:**  
      * **Originality: 5/5**  
      * **Coolness: 5/5**  
      * **Accessibility: 0/5 (“kingdomcubed”? Kingdomcubed.com? Not two syllables)**  
      * **Shortenings: “Kingdom”, “KKK”**  
  * **SiegeVox**  
    * **Elgenzay:**  
      * **Originality: 5/5**  
      * **Coolness: 5/5**  
      * **Shortening: “Siege” :thumbs\_down:**  
  * **Runetide**  
    * **Elgenzay:**  
      * **5/5**  
      * **Coolness: 5/5**  
      * **Accessibility: 5/5**  
      * **Rolls-right-off-the-tongue value: 5/5**  
      * **Shortenings: “Rune”/”Tide”? But I don’t think so.**  
  * VoxelReign  
  * ThunderVox  
  * ArcaneThrone  
* World Names (+“Online” or “Land of”; in this case, the main world would also be named this)  
  * Jaikoria  
  * Epheria  
  * Epherea  
  * Ephethia  
  * Alerelia  
  * Isethari  
* Ancient Realms  
* ~~Age of Terra~~  
* Ancient Terra  
* Related words to brainstorm with?  
  * Voxel  
  * Kingdom  
  * Realm  
  * Faction  
  * Block  
  * Siege  
  * Reign  
* SaltyBlocks

# 

# Monetization Ideas

* Market  
  * Trade I for I  
  * Trade I for C (Credits/Gold/USD) (or vice-versa)  
  * Trade Credits for Gold (or vice-versa)  
  * Trade USD for Gold/Credits (or vice-versa)  
* Auction  
  * Place item for auction (against Credits, Gold, or USD)  
* Market/Auction  
  * Facilitate buying and selling of items/characters between players for IRL money  
  * Take 20% or so  
* Credits  
  * Exchange for gold on the market  
  * Purchase  
    * Cosmetics  
    * Extra character slots  
    * Account bank capacity  
    * Character reroll tokens  
      * Class, race, appearance, name, skills, reputation(?)  
    * Clan world  
      * Small  
      * Medium  
      * Large  
  * Pay for chunk loading?  
* Custom multiverse  
  * A “tenant” on the multi-tenant server with its own ACL  
  * Probably slotted and something like $5-$10/slot/mo minimum $50/mo.  
  * Could be cool for larger streamers or events?  
* Character name/appearance change  
* Clan donations?  
* IRL Swag  
* Advertisements?


# Technical stuff \- Ignore below

# Data Types

## Region

Stored in Cassandra (PK: World Id, X, Z)

* World Id \- uuid  
* X \- long  
* Z \- long  
* Chunk Data Id \- uuid  
* Instance Ids \- uuid\[\]  
* New Instance Template \- InstanceTemplate  
* Difficulty level \- int  
* Settlements

## Instance

Stored in Cassandra (PK: Id)

* Id \- uuid  
* Entities \- Entity\[\]  
* Items \- DroppedItem\[\]

## InstanceTemplate

* Entities \- Entity\[\]

## Entity

Stored in Cassandra (PK: Id)

* Id \- uuid  
* Type \- EntityType Enum  
* Inventory Id \- uuid  
* Health \- int  
* Position \- WorldPosition  
* Speed \- Vector  
* Accel \- Vector  
* Face \- NormalVector  
* Look \- NormalVector  
* Effects \- Effect\[\]

## WorldPosition

* World Id \- uuid  
* Region X \- long  
* Region Z \- long  
* Block X \- short  
* Block Y \- short  
* Block Z \- short  
* Offset X \- byte  
* Offset Y \- byte  
* Offset Z \- byte

## Vector

* X \- short  
* Y \- short  
* Z \- short

## NormalVector

* X \- byte  
* Y \- byte  
* Z \- byte

## Inventory

Stored in Cassandra (PK: Id)

* Id \- uuid  
* Name \- String  
* Max size \- long  
* Item Ids \- uuid\[\]

## RegionChunkJournal

Stored in Redis by Id.  Used to recover a Region after a Region Server crash.

* Id \- uuid  
* Entries \- RegionChunkJournalEntry\[\]

## RegionChunkJournalEntry

* X \- short  
* Y \- short  
* Z \- short  
* Block \- Block

## RegionChunkData

Serialized and stored in S3 by ID.

* Version \- long  
* Id \- uuid  
* Created At \- timestamp  
* Chunks \- Chunk\[64\]\[64\]  
* 

## Chunk

* Chunk Sections \- ChunkSection\[256\]  
* Columns \- Column\[16\]\[16\]

## Column

* Top \- int  
* Biome \- BiomeType Enum

## ChunkSection

* Blocks \- Block\[16\]\[16\]\[16\]

## Block

* Type \- BlockType Enum  
* Data \- Map\<String, String\>  
* Natural Light \- int  
* Artificial Light \- int

# Microservices

**External:**

* API  
  * POST /accounts  
    * Create account  
  * POST /login  
    * Exchange credentials for an auth token  
  * GET /characters \- Authed  
    * Lists my characters  
  * GET /chunks/:encryptedchunkid \- Authed  
    * Gets a safed chunk.  A safed chunk is a chunk with all non-exposed valuable blocks replaced with a plausible non-valuable replacement.  The player gateway will send updates as necessary to ensure uncovered blocks are correctly visible.  
* Player Gateway  
  * WS /gateway  
    * Establishes a websocket connection to the gateway.  This is used for all two-way communication between the client and the megaserver.  Chunks are requested out of band via the API above.

**Internal:**

* Account Server \- Stateless  
  * HTTP  
    * POST /accounts  
      * Creates an account  
    * GET /accounts/:id  
      * Gets an account  
    * POST /accounts/:id/characters  
      * Creates a character  
    * DELETE /accounts/:accountid/characters/:characterid  
      * Deletes a character  
    * DELETE /accounts/:id  
      * Deletes an account  
  * Topics  
    * account:creation  
    * account:{id}:update  
    * character:creation  
* Coordinator (ZK?)  
* Multiverse Server \- Stateless  
  * HTTP  
    * POST /multiverses  
      * Creates a new multiverse  
    * GET /multiverses  
      * Lists multiverses  
  * Topics  
    * multiverse:creation  
* Character Server  
  * HTTP  
    * POST /characters  
      * Loads a character on this character server  
    * GET /characters/:id  
      * Gets a character  
    * PUT /characters/:id  
      * Updates a character’s attributes  
    * DELETE /characters/:id  
      * Unloads a character from this character server  
  * Topics  
    * character:{id}:load  
    * character:{id}:update  
* Chat \- Stateless  
  * HTTP  
    * POST /chat/local  
    * POST /chat/settlement/:settlementid  
    * POST /chat/region/:worldid/:x/:z  
    * POST /chat/clan/:clanid  
    * POST /chat/whisper/:userid  
    * DELETE /chat/messages/:id  
  * Topics  
    * chat:local:{id}:{x}:{z}  
    * chat:settlement:{id}  
    * chat:region:{id}:{x}:{z}  
    * chat:clan:{id}  
    * chat:whisper:{id}  
    * chat:messages:{id}  
* World Generator \- Stateless  
  * HTTP  
    * GET /region/:worldid/:x/:z  
      * Generates a region  
* Quest Generator  
* Inventory Server \- Stateless  
  * HTTP  
    * POST /inventory  
      * Creates an inventory  
    * GET /inventory/:id  
      * Gets an inventory  
    * POST /inventory/:id  
      * Adds an item to an inventory  
    * DELETE /inventory/:id/:itemid  
      * Removes an item from an inventory  
    * DELETE /inventory/:id  
      * Deletes an inventory  
  * Topics  
    * inventory:create  
    * inventory:{id}:add  
    * inventory:{id}:remove  
    * inventory:{id}:delete  
* Item Server \- Stateless  
  * HTTP  
    * POST /items  
      * Creates an item  
    * GET /items/:id  
      * Gets an item  
    * PUT /items/:id  
      * Updates an item  
    * DELETE /items/:id  
      * Destroys an item  
  * Topics  
    * item:create  
    * item:{id}:update  
    * item:{id}:delete  
* Settlement Server  
  * HTTP  
    * POST /settlements  
      * Loads a settlement on this settlement server  
    * GET /settlements  
      * Lists settlements loaded on this settlement server  
    * GET /settlements/:id  
      * Gets a settlement  
    * PUT /settlements/:id  
      * Updates a settlement  
    * DELETE /settlements/:id  
      * Unloads a settlement on this settlement server  
  * Topics  
    * settlement:{id}:load  
    * settlement:{id}:update  
* Dungeon Server  
  * HTTP  
    * POST /dungeons  
      * Loads a dungeon on this dungeon server  
    * GET /dungeons  
      * Lists dungeons loaded on this dungeon server  
    * GET /dungeons/:id  
      * Gets a dungeon  
    * PUT /dungeons/:id  
      * Updates a dungeon  
    * DELETE /dungeons/:id  
      * Unloads a dungeon from this dungeon server  
  * Topics  
    * dungeon:{id}:load  
    * dungeon:{id}:update  
* World Server  
  * HTTP  
    * POST /worlds  
      * Loads a world on this world server  
    * GET /worlds  
      * Lists loaded worlds on this world server  
    * GET /worlds/:id  
      * Gets properties of a world  
    * PUT /worlds/:id  
      * Updates properties of a world  
    * POST /worlds/:id/entities  
      * Creates a new entity  
    * DELETE /worlds/:id  
      * Unloads a world from this world server  
  * Topics  
    * world:{id}:update  
    * world:{id}:load  
    * world:{id}:entities  
* Time Server  
  * HTTP  
    * GET /time  
      * Gets the current server time  
    * PUT /time  
      * Sets the current server time  
  * Topics  
    * time:clock  
* Region Server  
  * Talks to: World Server, World Generator  
  * HTTP  
    * POST /regions  
      * Loads a region on this region server  
    * GET /regions  
      * Lists regions loaded on this region server  
    * GET /regions/:worldid/:rx/:rz  
      * Gets chunk metadata  
    * GET /regions/:worldid/:rx/:rz/:cx/:cz/:sy  
      * Gets a chunk section  
    * PUT /regions/:worldid/:rx/:rz/:cx/:cz/:sy/:bx/:by/:bz  
      * Updates block.  
    * POST /regions/:worldid/:rx/:rz  
      * Bulk update of blocks.  
    * DELETE /regions/:worldid/:rx/:rz  
      * Unloads a region from this region server  
  * Topics  
    * region:{worldid}:{x}:{z}:blockupdate  
    * region:{worldid}:{x}:{z}:load  
* Instance Server  
  * HTTP  
    * POST /instances  
      * Loads an instance on this instance server  
    * GET /instances  
      * Lists instances loaded on this instance server  
    * POST /instances/:instanceid/entities  
      * Adds an entity in this instance  
    * GET /instances/:instanceid/entities  
      * Lists entities in this instance  
    * DELETE /instances/:instanceid/entities/:entityid  
      * Removes an entity from this instance  
    * DELETE /instances/:instanceid  
      * Unloads an instance from this instance server  
  * Topics  
    * instance:{id}:update  
    * instance:{id}:load  
* Chunk Section Server  
  * Talks to: Region Server  
  * Manages block maintenance.  
  * HTTP  
    * POST /chunksections  
      * Loads a chunk section on this chunk section server  
    * GET /chunksections  
      * Lists chunk sections loaded on this chunk section server  
    * DELETE /chunksections/:worldid/:rx/:rz/:cx/:cz/:sy  
      * Unloads a chunk section from this chunk section server  
  * Topics  
    * chunksection:{worldid}:{rx}:{rz}:{cx}:{cz}:{sy}:growth  
    * chunksection:{worldid}:{rx}:{rz}:{cx}:{cz}:{sy}:load  
* Entity Server  
  * HTTP  
    * POST /entities  
      * Loads an entity on this entity server  
    * GET /entities  
      * Lists entities loaded on this entity server  
    * PUT /entities/:id  
      * Updates an entity  
    * POST /entities/:id/move  
      * Moves an entity  
    * POST /entities/:id/kill  
      * Kills an entity  
    * DELETE /entities/:id  
      * Unloads an entity from this entity server  
  * Topics  
    * entity:{id}:move  
    * entity:{id}:update  
    * entity:{id}:load  
    * entity:{id}:despawn  
* AI Server  
  * HTTP  
    * POST /ai  
      * Takes control over an entity  
    * GET /ai  
      * Lists entities controlled by this AI server  
    * DELETE /ai/:id  
      * Relinquishes control over an entity  
  * Topics  
    * ai:{id}:load  
* Logic Server  
  * HTTP  
    * POST /logic  
      * Takes control over logic systems in a chunk section  
    * GET /logic  
      * Lists chunk sections controlled by this logic server  
    * DELETE /logic/:worldid/:rx/:rz/:cx/:cz/:sy  
      * Relinquishes control over logic systems in a chunk section  
  * Topics  
    * logic:{worldid}:{rx}:{rz}:{cx}:{cz}:{sy}:load  
    * logic:{worldid}:{rx}:{rz}:{cx}:{cz}:{sy}:update

Instances are loaded if:

* Any player is in it or a surrounding instance  
* Any entity in it has an active goal

Regions are loaded if:

* Any instance of the region is loaded  
* Any chunk section of the region is loaded

Chunk Sections are loaded if:

* They have a player in them  
* They have an entity with an active goal  
* They are within 7 chunk sections of a player

Entities are loaded if:

* They are in an instance that is loaded

Worlds are loaded if:

* They have a region that is loaded.

Dungeons are loaded if:

* The dungeon’s world is loaded.

Settlements are loaded if:

* Any entity that belongs to the settlement is loaded.

Characters are loaded if:

* Their entity is loaded

Logic is loaded for every loaded chunk section.  
AI is loaded for every eligible entity.